
ESET:
 RCALL PORTS_INIT
  RCALL CLR_MEM
   RCALL INTERRUPT_INIT
    RCALL ADC_INIT
     RCALL I2C_DS3231_START_INIT
      RCALL TIMER_INIT_0
       LDI REG16,1
        STS MENU_Z,REG16
         CLR REG21
          CLR REG16
           RCALL BUTTON_WAS_PRESSED

SEI

MAIN:
 RCALL KEYBOARD_PORTx
  RCALL CHK_MENU
   RCALL ADC_BAT_FILTER_CHK
    RCALL HALT_FUNCTION
     RJMP MAIN










;------------------------------------------
;ÔÓÍÊÖ²ß ÏÅÐÅÂ²ÐÊÈ ÄÎÂÃÎÒÐÈÂÀËÎÃÎ ÏÐÎÑÒÎÞ
;------------------------------------------
HALT_FUNCTION:
 LDS REG16,KEY_CODE
  CPI REG16,'N'
   BRNE NEED_ON
    LDS REG16,HALT_FLIP_REG
     TST REG16
      BREQ HALT_FUNCTION_OUT
       CBI PORTC,2 ;ÂÈÌÊÍÅÍÍß ²ÍÂÅÐÒÎÐÀ ;ÏÅÐÅÎÐ²ªÍÒÓÂÀÒÈ Ï²Ä ÑÏËß×ÈÉ ÐÅÆÈÌ
        CBI PORTB,2 ;ÂÈÌÊÍÅÍÍß ÌÊ

HALT_FUNCTION_CLR:
 LDI REG16,0xBC
  STS HALT_FLIP_BYTE,REG16
   LDI REG16,0x0C
    STS HALT_FLIP_BYTE+1,REG16
     CLR REG16
      STS HALT_FLIP_REG,REG16

HALT_FUNCTION_OUT:
 RET

NEED_ON:
 SBI PORTC,2 ;ÂÂ²ÌÊÍÅÍÍß ²ÍÂÅÐÒÎÐÀ
  SBI PORTB,2 ;ÂÂ²ÌÊÍÅÍÍß ÏÎÄÀ×² ÆÈÂËÅÍÍß ÄÎ ÌÊ ÒÀ ÏÅÐÅÔÅÐ²¯
   RJMP HALT_FUNCTION_CLR

HALT_INCREMENT:
 LDS REG16,HALT_FLIP_BYTE
  LDS REG17,HALT_FLIP_BYTE+1
   SUBI REG16,1
    SBCI REG17,0
     STS HALT_FLIP_BYTE,REG16
      STS HALT_FLIP_BYTE+1,REG17
       TST REG16
        BRNE NO_HALT
         TST REG17
          BRNE NO_HALT
           LDI REG16,1
            STS HALT_FLIP_REG,REG16

NO_HALT:
 RET
;------------------------------------------
;ÔÓÍÊÖ²ß ÂÈÁ²ÐÊÈ ÍÀÏÐßÌÊÓ ÌÅÍÞ ÏÎ ÃÎÐÈÇÎÍÒÀË²
;------------------------------------------









;-----------------------------------------------
;ÔÓÍÊÖ²ß ÍÀÁÎÐÓ ËÎÃ²Êè ÔÓÍÊÖ²ÎÍÓÂÀÍÍß ÇÌ²ÍÈ ÏÎËÎÆÅÍÍß ÌÅÍÞ
;-----------------------------------------------
MENU_ERR_CLR: ;ÏÎÌÈËÊÀ Õ-ÃÎÐÈÇÎÍÒÀË² ÌÅÍÞ + ÎÁÍÓËÅÍÍß ÀÄÐÅÑÓ
 CLR REG16
  STS MENU_X,REG16
   STS MENU_Y,REG16
    STS MENU_Z,REG16
     RET

TIME_MENU_LOGIC:
 RJMP TIME_MENU_LOGIC_L ;ÑÊÀ×ÎÊ ÍÀ ÌÅÍÞ ËÎÃ²ÊÈ ÁËÎÊ²Â ×ÀÑÓ

DATE_MENU_LOGIC:
 RJMP DATE_MENU_LOGIC_L ;ÑÊÀ×ÎÊ ÍÀ ÌÅÍÞ ËÎÃ²ÊÈ ÁËÎÊ²Â ÄÀÒÈ

TEMPERATURE_MENU_LOGIC:
 RJMP TEMPERATURE_MENU_LOGIC_L ;ÑÊÀ×ÎÊ ÍÀ ÌÅÍÞ ËÎÃ²ÊÈ ÁËÎÊ²Â ÒÅÌÏÅÐÀÒÓÐÈ

INTERNAL_LOGIC: ;ÃÎËÎÂÍÀ ÔÓÍÊÖ²ß ËÎÃ²ÊÈ ÒÀ ÇÌ²ÍÈ ÀÄÐÅÑ²Â + ÎÁÐÎÁÊÓ ËÎÃ²ÊÈ ÍÀÒÈÑÊÀÍÜ
 LDS REG16,MENU_X
  CPI REG16,0
   BREQ TIME_MENU_LOGIC 
    CPI REG16,1
     BREQ DATE_MENU_LOGIC
      CPI REG16,2
       BREQ TEMPERATURE_MENU_LOGIC
        CPI REG16,3
         BRSH MENU_ERR_CLR
;-----------------------------------------------
;ÔÓÍÊÖ²ß ÍÀÁÎÐÓ ËÎÃ²ÊÈ ÏÎËÎÆÅÍÍß ÌÅÍÞ ×ÀÑÓ ÏÎ Y
;-----------------------------------------------
TIME_MENU_LOGIC_L: ;ÌÅÍÞ ×ÀÑÓ, ÏÅÐÅÂ²ÐÊÀ Ð²ÂÍß ÂÅÐÒÈÊÀË² Ó0, Ó1, Ó2 
 LDS REG16,MENU_Y
  CPI REG16,0
   BREQ TIME_MENU_LOGIC_STAGE_Y0_L
    CPI REG16,1
     BREQ TIME_MENU_LOGIC_STAGE_Y1_L
      CPI REG16,2
       BREQ TIME_MENU_LOGIC_STAGE_Y2_L
        CLR REG16
         STS MENU_Y,REG16
          RET

TIME_MENU_LOGIC_STAGE_Y0_L: ;ÌÅÍÞ ×ÀÑÓ, Ð²ÂÅÍÜ Ó0, ÎÁÐÎÁÊÀ ÃÎÐÈÇÎÍÒÀËÜÍÎÃÎ ÑÊÐÎËÓ, ÇÌ²ÍÈ ÒÈÏÓ ÌÅÍÞ, ÒÀ ÓÌÎÂÈ ÏÅÐÅÕÎÄÓ ÍÀ Ð²ÂÅÍÜ - Ó1
 RCALL LOGIC_VECTOR_SUPERVISOR_LEVEL_Y0
  RET

TIME_MENU_LOGIC_STAGE_Y1_L: ;Ð²ÂÅÍÜ ÌÅÍÞ ×ÀÑÓ X0,Ó-1,Z0
 RCALL LOGIC_VECTOR_SUPERVISOR_LEVEL_Y1
  RET

TIME_MENU_LOGIC_STAGE_Y2_L:
 LDS REG16,KEY_CODE
  CPI REG16,'R'
   BRNE TMLSY2L_L
    LDS REG16,SUB_MENU_6
     CPI REG16,0
      BRNE INC_SEC_TEN
       RJMP INC_SET_SEC_ONE

INC_SEC_TEN:
 CPI REG16,1
  BRNE INC_MIN_ONE
   RJMP INC_SET_SEC_TEN
      
INC_MIN_ONE:
 CPI REG16,2
  BRNE INC_MIN_TEN
   RJMP INC_SET_MIN_ONE

INC_MIN_TEN:
 CPI REG16,3
  BRNE INC_HOUR_ONE
   RJMP INC_SET_MIN_TEN

INC_HOUR_ONE:
 CPI REG16,4
  BRNE INC_HOUR_TEN
   RJMP INC_SET_HOUR_ONE

INC_HOUR_TEN:
 CPI REG16,5
  BRNE TIME_INC_ERR
   RJMP INC_SET_HOUR_TEN
    RET

TIME_INC_ERR:
 RET

TMLSY2L_L:
 LDS REG16,KEY_CODE
  CPI REG16,'L'
   BRNE TMLSY2L_C
    LDS REG16,SUB_MENU_6
     CPI REG16,0
      BRNE DEC_SEC_TEN
       RJMP DEC_SET_SEC_ONE

DEC_SEC_TEN:
 CPI REG16,1
  BRNE DEC_MIN_ONE
   RJMP DEC_SET_SEC_TEN
      
DEC_MIN_ONE:
 CPI REG16,2
  BRNE DEC_MIN_TEN
   RJMP DEC_SET_MIN_ONE

DEC_MIN_TEN:
 CPI REG16,3
  BRNE DEC_HOUR_ONE
   RJMP DEC_SET_MIN_TEN

DEC_HOUR_ONE:
 CPI REG16,4
  BRNE DEC_HOUR_TEN
   RJMP DEC_SET_HOUR_ONE

DEC_HOUR_TEN:
 CPI REG16,5
  BRNE TIME_DEC_ERR
   RJMP DEC_SET_HOUR_TEN
    RET

TIME_DEC_ERR:
 RET

TMLSY2L_C:
 LDS REG16,KEY_CODE
  CPI REG16,'C'
   BRNE TMLSY2L_OUT
    LDI REG16,1
     STS MENU_Y,REG16
      CLR REG16
       STS KEY_CODE,REG16

TMLSY2L_OUT:
 RET

CLT_KEY:
 CLR REG16
  STS KEY_CODE,REG16
   RET
;-----------------------------------------------
;ÔÓÍÊÖ²ß ÊÎÐÅÊÒÓÂÀÍÍß ÒÀ ÂÂÎÄÓ ÄÀÍÍÈÕ ×ÀÑÓ
;-----------------------------------------------
INC_SET_SEC_ONE:
 LDS REG16,T_SECONDS
  MOV REG17,REG16
   RCALL INC_9_T
    STS T_SECONDS,REG16
     RJMP CLT_KEY

INC_SET_SEC_TEN:
 LDS REG16,T_SECONDS
  MOV REG17,REG16
   RCALL INC_5_T
    STS T_SECONDS,REG16
     RJMP CLT_KEY

INC_SET_MIN_ONE:
 LDS REG16,T_MINUTES
  MOV REG17,REG16
   RCALL INC_9_T
    STS T_MINUTES,REG16
     RJMP CLT_KEY

INC_SET_MIN_TEN:
 LDS REG16,T_MINUTES
  MOV REG17,REG16
   RCALL INC_5_T
    STS T_MINUTES,REG16
     RJMP CLT_KEY

INC_SET_HOUR_ONE:
 LDS REG16,T_HOURS
  STS TIME_BUFFER,REG16
   RCALL INC_3_9_T
    LDS REG16,TIME_BUFFER
     STS T_HOURS,REG16
      RJMP CLT_KEY

INC_SET_HOUR_TEN:
 LDS REG16,T_HOURS
  STS TIME_BUFFER,REG16
   RCALL INC_2_T
    LDS REG16,TIME_BUFFER
     STS T_HOURS,REG16
      RJMP CLT_KEY

DEC_SET_SEC_ONE:
 LDS REG16,T_SECONDS
  MOV REG17,REG16
   RCALL DEC_9_T
    STS T_SECONDS,REG16
     RJMP CLT_KEY

DEC_SET_SEC_TEN:
 LDS REG16,T_SECONDS
  MOV REG17,REG16
   RCALL DEC_5_T
    STS T_SECONDS,REG16
     RJMP CLT_KEY

DEC_SET_MIN_ONE:
 LDS REG16,T_MINUTES
  MOV REG17,REG16
   RCALL DEC_9_T
    STS T_MINUTES,REG16
     RJMP CLT_KEY

DEC_SET_MIN_TEN:
 LDS REG16,T_MINUTES
  MOV REG17,REG16
   RCALL DEC_5_T
    STS T_MINUTES,REG16
     RJMP CLT_KEY

DEC_SET_HOUR_ONE:
 LDS REG16,T_HOURS
  STS TIME_BUFFER,REG16
   RCALL DEC_3_9_T
    LDS REG16,TIME_BUFFER
     STS T_HOURS,REG16
      RJMP CLT_KEY

DEC_SET_HOUR_TEN:
 LDS REG16,T_HOURS
  STS TIME_BUFFER,REG16
   RCALL DEC_2_T
    LDS REG16,TIME_BUFFER
     STS T_HOURS,REG16
      RJMP CLT_KEY

INC_9_T:
 ANDI REG16,0b00001111
  CPI REG16,0x09
   BREQ OVERLAP_INC_SET_SEC_ONE
    INC REG16
     RJMP INC_SET_SEC_ONE_SAVE

OVERLAP_INC_SET_SEC_ONE:
 CLR REG16

INC_SET_SEC_ONE_SAVE:
 ANDI REG17,0b11110000
  ADD REG16,REG17
   RET

INC_5_T:
 ANDI REG16,0b11110000
  CPI REG16,0x50
   BREQ OVERLAP_INC_SET_SEC_TEN
    SUBI REG16,-16
     RJMP INC_SET_SEC_TEN_SAVE

OVERLAP_INC_SET_SEC_TEN:
 CLR REG16

INC_SET_SEC_TEN_SAVE:
 ANDI REG17,0b00001111
  ADD REG16,REG17
   RET

INC_3_9_T:
 LDS REG16,TIME_BUFFER
  ANDI REG16,0b11110000
   CPI REG16,0x20
    BRLO HOURS_MAX_INC_X9
     LDS REG16,TIME_BUFFER
      ANDI REG16,0b00001111
       CPI REG16,0x03
        BREQ OVERLAP_INC_SET_HOUR_ONE
         INC REG16
          RJMP INC_SET_HOUR_ONE_SAVE

HOURS_MAX_INC_X9:
 LDS REG16,TIME_BUFFER
  ANDI REG16,0b00001111
   CPI REG16,0x09
    BREQ OVERLAP_INC_SET_HOUR_ONE
     INC REG16
      RJMP INC_SET_HOUR_ONE_SAVE

OVERLAP_INC_SET_HOUR_ONE:
 CLR REG16

INC_SET_HOUR_ONE_SAVE:
 LDS REG17,TIME_BUFFER
  ANDI REG17,0b11110000
   ADD REG16,REG17
    STS TIME_BUFFER,REG16
     RET

INC_2_T:
 LDS REG16,TIME_BUFFER
  ANDI REG16,0b11110000
   CPI REG16,0x20
    BRSH OVERLAP_INC_SET_HOUR_TEN
     SUBI REG16,-16
      LDS REG17,TIME_BUFFER
       ANDI REG17,0b11110000
        CPI REG17,0x10
         BREQ HOURS_INC_CLR
          RJMP INC_SET_HOUR_TEN_SAVE

HOURS_INC_CLR:
 LDS REG17,TIME_BUFFER
  ANDI REG17,0b00001111
   CPI REG17,0x04
    BRSH SET_MAX_23_TOP
     RJMP INC_SET_HOUR_TEN_SAVE

OVERLAP_INC_SET_HOUR_TEN:
 CLR REG16

INC_SET_HOUR_TEN_SAVE:
 LDS REG17,TIME_BUFFER
  ANDI REG17,0b00001111
   ADD REG16,REG17
    STS TIME_BUFFER,REG16
     RJMP CLT_KEY

SET_MAX_23_TOP:
 LDI REG16,0x23
  STS TIME_BUFFER,REG16
   RET

DEC_9_T:
 ANDI REG16,0b00001111
  TST REG16
   BREQ OVERLAP_DEC_SET_SEC_ONE
    DEC REG16
     RJMP DEC_SET_SEC_ONE_SAVE

OVERLAP_DEC_SET_SEC_ONE:
 LDI REG16,0x09

DEC_SET_SEC_ONE_SAVE:
 ANDI REG17,0b11110000
  ADD REG16,REG17
   RET

DEC_5_T:
 ANDI REG16,0b11110000
  TST REG16
   BREQ OVERLAP_DEC_SET_SEC_TEN
    SUBI REG16,0b00010000
     RJMP DEC_SET_SEC_TEN_SAVE

OVERLAP_DEC_SET_SEC_TEN:
 LDI REG16,0x50

DEC_SET_SEC_TEN_SAVE:
 ANDI REG17,0b00001111
  ADD REG16,REG17
   RET

DEC_3_9_T:
 LDS REG16,TIME_BUFFER
  ANDI REG16,0b00001111
   TST REG16
    BREQ OVERLAP_DEC_SET_HOUR_ONE
     DEC REG16
      RJMP DEC_SET_HOUR_ONE_SAVE

OVERLAP_DEC_SET_HOUR_ONE:
 LDS REG16,TIME_BUFFER
  ANDI REG16,0b11110000
   CPI REG16,0x20
    BRSH HOURS_MAX_X3
     LDI REG16,0x09
      RJMP DEC_SET_HOUR_ONE_SAVE

HOURS_MAX_X3:
 LDI REG16,0x03

DEC_SET_HOUR_ONE_SAVE:
 LDS REG17,TIME_BUFFER
  ANDI REG17,0b11110000
   ADD REG16,REG17
    STS TIME_BUFFER,REG16
     RET

DEC_2_T:
 LDS REG16,TIME_BUFFER
  ANDI REG16,0b11110000
   TST REG16
    BREQ OVERLAP_DEC_SET_HOUR_TEN
     SUBI REG16,0b00010000
      RJMP DEC_SET_HOUR_TEN_SAVE

OVERLAP_DEC_SET_HOUR_TEN:
 LDS REG16,TIME_BUFFER
  ANDI REG16,0b00001111
   CPI REG16,0x04
    BRSH DEC_SET_HOUR_TEN_RESAVE
     LDI REG16,0x20

DEC_SET_HOUR_TEN_SAVE:
 LDS REG17,TIME_BUFFER
  ANDI REG17,0b00001111
   ADD REG16,REG17
    STS TIME_BUFFER,REG16
     RJMP CLT_KEY

DEC_SET_HOUR_TEN_RESAVE:
 LDI REG16,0x23
  STS TIME_BUFFER,REG16
   RET
;-----------------------------------------------
;ÔÓÍÊÖ²ß ÍÀÁÎÐÓ ËÎÃ²ÊÈ ÏÎËÎÆÅÍÍß ÌÅÍÞ ÄÀÒÈ ÏÎ Y
;-----------------------------------------------
DATE_MENU_LOGIC_L:
 LDS REG16,MENU_Y
  CPI REG16,0
   BREQ DATE_MENU_LOGIC_STAGE_Y0_L
    CPI REG16,1
     BREQ DATE_MENU_LOGIC_STAGE_Y1_L
      CPI REG16,2
       BREQ DATE_MENU_LOGIC_STAGE_Y2_L
        CLR REG16
         STS MENU_Y,REG16
          RET

DATE_MENU_LOGIC_STAGE_Y0_L:
 RCALL LOGIC_VECTOR_SUPERVISOR_LEVEL_Y0
  RET

DATE_MENU_LOGIC_STAGE_Y1_L:
 RCALL LOGIC_VECTOR_SUPERVISOR_LEVEL_Y1
  RET

DATE_MENU_LOGIC_STAGE_Y2_L:
 LDS REG16,KEY_CODE
  CPI REG16,'R'
   BRNE DATE_SET_L
    LDS REG16,SUB_MENU_6
     CPI REG16,0
      BREQ INC_DATE_YEAR
       CPI REG16,1
        BREQ INC_DATE_YEAR
         CPI REG16,2
          BREQ INC_DATE_MONTH
           CPI REG16,3
            BREQ INC_DATE_MONTH
             CPI REG16,4
              BREQ INC_DATE_DAY
               CPI REG16,5
                BREQ INC_DATE_DAY
                 RET

INC_DATE_YEAR:
 RJMP INC_DATE_Y

INC_DATE_MONTH:
 RJMP INC_DATE_M

INC_DATE_DAY:
 RJMP INC_DATE_D

DATE_SET_L:
 LDS REG16,KEY_CODE
  CPI REG16,'L'
   BRNE DATE_SET_C
    LDS REG16,SUB_MENU_6
     CPI REG16,0
      BREQ DEC_DATE_YEAR
       CPI REG16,1
        BREQ DEC_DATE_YEAR
         CPI REG16,2
          BREQ DEC_DATE_MONTH
           CPI REG16,3
            BREQ DEC_DATE_MONTH
             CPI REG16,4
              BREQ DEC_DATE_DAY
               CPI REG16,5
                BREQ DEC_DATE_DAY
                 RET

DEC_DATE_YEAR:
 RJMP DEC_DATE_Y

DEC_DATE_MONTH:
 RJMP DEC_DATE_M

DEC_DATE_DAY:
 RJMP DEC_DATE_D

DATE_SET_C:
 RJMP TMLSY2L_C
;------------------------------------------------
;
;------------------------------------------------
INC_DATE_Y:
 LDS REG16,D_YEAR
  MOV REG17,REG16
   CPI REG17,0x99
    BRSH DATE_Y_CLR
     ANDI REG17,0b00001111
      CPI REG17,0x09
       BRSH INC_AND_CLR
        INC REG17
         RJMP SIMPLE_INC

INC_AND_CLR:
 LDI REG17,0x10

SIMPLE_INC:
 ANDI REG16,0b11110000
  ADD REG16,REG17
   STS D_YEAR,REG16
    RJMP INC_DATE_Y_OUT

DATE_Y_CLR:
 CLR REG16
  STS D_YEAR,REG16

INC_DATE_Y_OUT:
 RCALL DAY_LIMIT_COMPARE
  RJMP CLT_KEY

INC_DATE_M:
 LDS REG16,D_MONTHS
  MOV REG17,REG16
   CPI REG17,0x12
    BRSH DATE_M_CLR
     ANDI REG17,0b00001111
      CPI REG17,0x09
       BRSH INC_M
        INC REG17
         RJMP SIMPLE_M_INC

INC_M:
 LDI REG17,0x10

SIMPLE_M_INC:
 ANDI REG16,0b11110000
  ADD REG16,REG17
   STS D_MONTHS,REG16
    RJMP INC_DATE_M_OUT

DATE_M_CLR:
 LDI REG16,1
  STS D_MONTHS,REG16

INC_DATE_M_OUT:
 RCALL DAY_LIMIT_COMPARE
  RJMP CLT_KEY

INC_DATE_D:
 RCALL DAY_LIMIT_COMPARE
  LDS REG16,D_DAY
   MOV REG17,REG16
    LDS REG18,DATE_SET_LIMIT
     CP REG17,REG18
      BRSH DATE_D_CLR
       ANDI REG17,0b00001111
        CPI REG17,0x09
         BRSH INC_D
          INC REG17
           RJMP SIMPLE_D_INC

INC_D:
 LDI REG17,0x10

SIMPLE_D_INC:
 ANDI REG16,0b11110000
  ADD REG16,REG17
   STS D_DAY,REG16
    RJMP INC_DATE_D_OUT

DATE_D_CLR:
 LDI REG16,1
  STS D_DAY,REG16

INC_DATE_D_OUT:
 RJMP CLT_KEY

DEC_DATE_Y:
 LDS REG16,D_YEAR
  MOV REG17,REG16
   CPI REG17,0x00
    BREQ DATE_Y_TOP
     ANDI REG17,0b00001111
      CPI REG17,0x00
       BREQ DEC_AND_CLR
        DEC REG17
         RJMP SIMPLE_DEC

DEC_AND_CLR:
 LDI REG17,0x09
  SUBI REG16,0x10

SIMPLE_DEC:
 ANDI REG16,0b11110000
  ADD REG16,REG17
   STS D_YEAR,REG16
    RJMP DEC_DATE_Y_OUT

DATE_Y_TOP:
 LDI REG16,0x99
  STS D_YEAR,REG16

DEC_DATE_Y_OUT:
 RCALL DAY_LIMIT_COMPARE
  RJMP CLT_KEY

DEC_DATE_M:
 LDS REG16,D_MONTHS
  MOV REG17,REG16
   CPI REG17,0x01
    BREQ DATE_M_TOP
     ANDI REG17,0b00001111
      CPI REG17,0x00
       BREQ DEC_M
        DEC REG17
         RJMP SIMPLE_M_DEC

DEC_M:
 LDI REG17,0x09
  SUBI REG16,0x10

SIMPLE_M_DEC:
 ANDI REG16,0b11110000
  ADD REG16,REG17
   STS D_MONTHS,REG16
    RJMP DEC_DATE_M_OUT

DATE_M_TOP:
 LDI REG16,0x12
  STS D_MONTHS,REG16

DEC_DATE_M_OUT:
 RCALL DAY_LIMIT_COMPARE
  RJMP CLT_KEY

DEC_DATE_D:
 RCALL DAY_LIMIT_COMPARE
  LDS REG16,D_DAY
   MOV REG17,REG16
    CPI REG17,0x01
     BREQ DATE_D_TOP
      ANDI REG17,0b00001111
       CPI REG17,0x00
        BREQ DEC_D
         DEC REG17
          RJMP SIMPLE_D_DEC

DEC_D:
 LDI REG17,0x09
  SUBI REG16,0x10

SIMPLE_D_DEC:
 ANDI REG16,0b11110000
  ADD REG16,REG17
   STS D_DAY,REG16
    RJMP DEC_DATE_D_OUT

DATE_D_TOP:
 LDS REG16,DATE_SET_LIMIT
  STS D_DAY,REG16

DEC_DATE_D_OUT:
 RJMP CLT_KEY

DAY_LIMIT_COMPARE:
 LDS REG16,D_MONTHS
  ANDI REG16,0b01111111
   CPI REG16,0x02
    BREQ DAY_4_Y
     CPI REG16,0x04
      BREQ DAY_30
       CPI REG16,0x06
        BREQ DAY_30
         CPI REG16,0x09
          BREQ DAY_30
           CPI REG16,0x11
            BREQ DAY_30
             LDI REG16,0x31
              STS DATE_SET_LIMIT,REG16
               RJMP DAY_LIMIT_OUT

DAY_30:
 LDI REG16,0x30
  STS DATE_SET_LIMIT,REG16
   RJMP DAY_LIMIT_OUT

DAY_4_Y:
 LDS REG16,D_YEAR
  CPI REG16,0x00
   BREQ DAY_29
    CPI REG16,0x04
     BREQ DAY_29
      CPI REG16,0x08
       BREQ DAY_29
        CPI REG16,0x12
         BREQ DAY_29
          CPI REG16,0x16
           BREQ DAY_29
            CPI REG16,0x20
             BREQ DAY_29
              CPI REG16,0x24
               BREQ DAY_29
                CPI REG16,0x28
                 BREQ DAY_29
                  CPI REG16,0x32
                   BREQ DAY_29
                    CPI REG16,0x36
                     BREQ DAY_29
                      CPI REG16,0x40
                       BREQ DAY_29
                        CPI REG16,0x44
                         BREQ DAY_29
                          CPI REG16,0x48
                           BREQ DAY_29
                            CPI REG16,0x52
                             BREQ DAY_29
                              CPI REG16,0x56
                               BREQ DAY_29
                                CPI REG16,0x60
                                 BREQ DAY_29
                                  CPI REG16,0x64
                                   BREQ DAY_29
                                    CPI REG16,0x68
                                     BREQ DAY_29
                                      CPI REG16,0x72
                                       BREQ DAY_29
                                        CPI REG16,0x76
                                         BREQ DAY_29
                                          CPI REG16,0x80
                                           BREQ DAY_29
                                            CPI REG16,0x84
                                             BREQ DAY_29
                                              CPI REG16,0x88
                                               BREQ DAY_29
                                                CPI REG16,0x92
                                                 BREQ DAY_29
                                                  CPI REG16,0x96
                                                   BREQ DAY_29

DAY_28:
 LDI REG16,0x28
  STS DATE_SET_LIMIT,REG16
   RJMP DAY_LIMIT_OUT

DAY_29:
 LDI REG16,0x29
  STS DATE_SET_LIMIT,REG16

DAY_LIMIT_OUT:
 LDS REG17,D_DAY
  CP REG17,REG16
   BRSH GET_TOP_DAY

JUST_OUT:
 RET

GET_TOP_DAY:
 LDS REG16,DATE_SET_LIMIT
  STS D_DAY,REG16
   RET
;-----------------------------------------------
;ÔÓÍÊÖ²ß ÍÀÁÎÐÓ ËÎÃ²ÊÈ ÏÎËÎÆÅÍÍß ÌÅÍÞ ÒÅÌÏÅÐÀÒÓÐÈ ÏÎ Y
;-----------------------------------------------
TEMPERATURE_MENU_LOGIC_L: ;ÀÄÐÅÑÀÖ²ß ÌÅÍÞ ÒÅÌÏÅÐÀÒÓÐÈ ÍÀ Ð²ÂÍ² Ó-0 ÒÀ Ó-1
 LDS REG16,MENU_Y
  CPI REG16,0
   BREQ TEMPERATURE_MENU_LOGIC_STAGE_Y0
    CPI REG16,1
     BREQ TEMPERATURE_MENU_LOGIC_STAGE_Y1
      CLR REG16
       STS MENU_Y,REG16
        RET

TEMPERATURE_MENU_LOGIC_STAGE_Y0: ;Ð²ÂÅÍÜ Ó-0 ÌÅÍÞ ÒÅÌÏÅÐÀÒÓÐÈ
 RCALL LOGIC_VECTOR_SUPERVISOR_LEVEL_Y0
  RET

TEMPERATURE_MENU_LOGIC_STAGE_Y1: ;Ð²ÂÅÍÜ Ó-1 ÌÅÍÞ ÍÀËÀØÒÓÂÀÍÍß ØÂÈÄÊÎÑÒ² ÕÎÄÓ ÃÎÄÈÍÍÈÊÀ
 LDS REG16,KEY_CODE
  CPI REG16,'L'
   BRNE SET_T_R
    RCALL DECREMENT_TIC_SPEED
     RCALL HOLD_CLR
      RET

SET_T_R:
 CPI REG16,'R'
  BRNE SET_T_C
   RCALL INCREMENT_TIC_SPEED
    RCALL HOLD_CLR
     RET

SET_T_C:
 RCALL OK_HOLD
  CLR REG16
   STS OK_FLIP,REG16

INTERNAL_LOGIC_OUT:
 RET
;-----------------------------------------------
;ÔÓÍÊÖ²ß ÍÀÁÎÐÓ ËÎÃ²ÊÈ ÇÌ²ÍÈ ÏÀÐÀÌÅÒÐÓ ÕÎÄÓ ÃÎÄÈÍÍÈÊÀ
;-----------------------------------------------
DECREMENT_TIC_SPEED: ;ÔÓÍÊÖ²ß ÄÅÊÐÈÌÅÍÒÓ ÏÀÐÀÌÅÒÐÓ ØÂÈÄÊÎÑÒ² ÕÎÄÓ ÃÎÄÈÍÍÈÊÀ
 LDS REG16,AGING_OFFSET
  MOV REG17,REG16
   ANDI REG17,0b10000000
    CPI REG17,0b10000000
     BREQ MINUS_AGING
      TST REG16
       BREQ DEC_ZERO
        DEC REG16
         STS AGING_OFFSET,REG16
          RJMP DECREMENT_AGING_OUT

DEC_ZERO:
 LDI REG16,0b10000001
  STS AGING_OFFSET,REG16
   RJMP DECREMENT_AGING_OUT

MINUS_AGING:
 ANDI REG16,0b01111111
  CPI REG16,99
   BRSH DECREMENT_AGING_OUT
    INC REG16
     LDI REG17,0b10000000
      ADD REG16,REG17
       STS AGING_OFFSET,REG16

DECREMENT_AGING_OUT:
 CLR REG16
  STS KEY_CODE,REG16
   RET

INCREMENT_TIC_SPEED: ;ÔÓÍÊÖ²ß ²ÍÊÐÅÌÅÍÒÓ ÏÀÐÀÌÅÒÐÓ ØÂÈÄÊÎÑÒ² ÕÎÄÓ ÃÎÄÈÍÍÈÊÀ
 LDS REG16,AGING_OFFSET
  MOV REG17,REG16
   ANDI REG17,0b10000000
    CPI REG17,0b10000000
     BREQ PLUS_AGING
      CPI REG16,99
       BRSH INCREMENT_AGING_OUT
        INC REG16
         STS AGING_OFFSET,REG16
          RJMP INCREMENT_AGING_OUT

INC_ZERO:
 CLR REG16
  STS AGING_OFFSET,REG16
   RJMP INCREMENT_AGING_OUT

PLUS_AGING:
 CPI REG16,0b10000001
  BREQ INC_ZERO
   ANDI REG16,0b01111111
    DEC REG16
     LDI REG17,0b10000000
      ADD REG16,REG17
       STS AGING_OFFSET,REG16

INCREMENT_AGING_OUT:
 CLR REG16
  STS KEY_CODE,REG16
   RET

;-----------------------------------------------
;ÁËÎÊ Ô²ËÜÒÐÀÖ²¯ ÇÍÀ×ÅÍÍß ÁÀÒÀÐÅ¯
;-----------------------------------------------
ADC_BAT_FILTER_CHK: ;Ô²ËÜÒÐÀÖ²ß ÇÍÀ×ÅÍÍß ÁÀÒÀÐÅ¯
 LDS REG16,ADC_VAL_FLIP
  TST REG16
   BREQ ADC_BAT_FILTER_OUT
    LDS REG16,ADC_BAT_CYCLES_FILTER
     TST REG16
      BREQ START_FILTER
       LDS REG16,ADC_BAT_CYCLES_FILTER
        DEC REG16
         STS ADC_BAT_CYCLES_FILTER,REG16
          LDS REG16,ADC_BAT_VALUE_TEMP
           CLR REG17
            LDS REG18,ADC_BAT_RES_FILTER
             LDS REG19,ADC_BAT_RES_FILTER+1
              ADD REG18,REG16
               ADC REG19,REG17
                STS ADC_BAT_RES_FILTER,REG18
                 STS ADC_BAT_RES_FILTER+1,REG19
                  RJMP CLR_FLIP

START_FILTER:
 LDI REG18,7
  LDS REG16,ADC_BAT_RES_FILTER
   LDS REG17,ADC_BAT_RES_FILTER+1

FILTER_LOOP:
 ROR REG17
  ROR REG16
   CLC
    DEC REG18
     BRNE FILTER_LOOP
      STS ADC_BAT_RES,REG16
       CLR REG16
        STS ADC_BAT_RES_FILTER,REG16
         STS ADC_BAT_RES_FILTER+1,REG16
          LDI REG16,128
           STS ADC_BAT_CYCLES_FILTER,REG16

CLR_FLIP:
 CLR REG16
  STS ADC_VAL_FLIP,REG16

ADC_BAT_FILTER_OUT:
 RET
;-----------------------------------------------
;ÔÓÍÊÖ²ß ÍÀÁÎÐÓ ËÎÃ²ÊÈ ÏÎËÎÆÅÍÍß ÌÅÍÞ ÏÎ "X" ÍÀ Ð²ÂÍ² "Ó0"
;-----------------------------------------------
LOGIC_VECTOR_SUPERVISOR_LEVEL_Y0:
 LDS REG16,KEY_CODE
  CPI REG16,'R'
   BRNE CHK_UN_L
    LDS REG16,MENU_Z
     TST REG16
      BREQ SUB_MENU_Z0_R

SUB_MENU_Z1_R:
 CLR REG16
  STS MENU_Z,REG16
   RCALL CLR_KC_R_DDOTS
    RET

SUB_MENU_Z0_R:
 LDS REG16,MENU_X
  TST REG16
   BREQ IF_X0_R
    RCALL RIGHT_X_SLIDE
     LDI REG16,1
      STS MENU_Z,REG16
       RET

IF_X0_R:
 RCALL CLR_KC_R_DDOTS
  RET

CHK_UN_L:
 CPI REG16,'L'
  BRNE CHK_UN_C
   LDS REG16,MENU_Z
    TST REG16
     BREQ SUB_MENU_Z0_L

SUB_MENU_Z1_L:
 LDS REG16,MENU_X
  CPI REG16,1
   BREQ IF_X1_Z1
    CPI REG16,2
     BREQ IF_X2_Z0
      RCALL LEFT_X_SLIDE
       CLR REG16
        STS MENU_Z,REG16
         RET

IF_X2_Z0:
 RCALL ON_ALL_DOT
  RET

IF_X1_Z1:
 LDI REG16,2
  STS MENU_X,REG16
   CLR REG16
    STS MENU_Z,REG16;NONE CLR KEY CODE 
     RCALL ON_ALL_DOT
      RET

SUB_MENU_Z0_L:
 LDS REG16,MENU_X
  CPI REG16,2
   BREQ IF_X2_L
    LDI REG16,1
     STS MENU_Z,REG16
      RCALL CLR_KC_L_DDOTS
       RET

IF_X2_L:
 RCALL ON_ALL_DOT
  RET

CHK_UN_C:
 CPI REG16,'C'
  BRNE NO_UN_INPUT
   LDS REG16,MENU_X
    CPI REG16,2
     BREQ UP_FROM_X2
      LDS REG16,MENU_Z
       CPI REG16,1
        BREQ UP_FROM_Z1
         TST REG16
          BREQ UP_FROM_Z0
           RET

UP_FROM_Z0:
 CLR REG16
  STS SUB_MENU_6,REG16
   RJMP UP_FROM_X2

UP_FROM_Z1:
 LDI REG16,2
  STS SUB_MENU_6,REG16

UP_FROM_X2:
 RCALL VERTICAL_Y_SLIDE_D
  RET

NO_UN_INPUT:
 RET
;-----------------------------------------------
;ÔÓÍÊÖ²ß ÍÀÁÎÐÓ ËÎÃ²ÊÈ ÏÎËÎÆÅÍÍß ÌÅÍÞ ÏÎ "X" ÍÀ Ð²ÂÍ² "Ó1"
;-----------------------------------------------
LOGIC_VECTOR_SUPERVISOR_LEVEL_Y1:
 LDS REG16,MENU_Z
  CPI REG16,1
   BREQ LEVEL_Y1_Z1

LEVEL_Y1_Z0:
 LDS REG16,KEY_CODE
  CPI REG16,'L'
   BRNE LEVEL_Y1_Z0_R
    LDS REG16,SUB_MENU_6
     CPI REG16,3
      BREQ Z0_TOP
       INC REG16
        STS SUB_MENU_6,REG16
         CLR REG16
          STS KEY_CODE,REG16
           RCALL HOLD_CLR
            RET

Z0_TOP:
 LDI REG16,1
  STS MENU_Z,REG16
   CLR REG16
    STS KEY_CODE,REG16
     RCALL HOLD_CLR
      RET

LEVEL_Y1_Z0_R:
 LDS REG16,KEY_CODE
  CPI REG16,'R'
   BRNE LEVEL_Y1_Z_C
    LDS REG16,SUB_MENU_6
     TST REG16
      BREQ LEVEL_Y1_Z_LR_NONE
       DEC REG16
        STS SUB_MENU_6,REG16
         CLR REG16
          STS KEY_CODE,REG16
           RCALL HOLD_CLR
            RET

LEVEL_Y1_Z_LR_NONE:
 CLR REG16
  STS KEY_CODE,REG16
   RET

LEVEL_Y1_Z1:
 LDS REG16,KEY_CODE
  CPI REG16,'L'
   BRNE LEVEL_Y1_Z1_R
    LDS REG16,SUB_MENU_6
     CPI REG16,5
      BREQ LEVEL_Y1_Z_LR_NONE
       INC REG16
        STS SUB_MENU_6,REG16
         CLR REG16
          STS KEY_CODE,REG16
           RCALL HOLD_CLR
            RET

LEVEL_Y1_Z1_R:
 LDS REG16,KEY_CODE
  CPI REG16,'R'
   BRNE LEVEL_Y1_Z_C
    LDS REG16,SUB_MENU_6
     CPI REG16,2
      BREQ Z1_BOTTOM
       DEC REG16
        STS SUB_MENU_6,REG16
         CLR REG16
          STS KEY_CODE,REG16
           RCALL HOLD_CLR
            RET

Z1_BOTTOM:
 CLR REG16
  STS MENU_Z,REG16
   STS KEY_CODE,REG16
    RCALL HOLD_CLR
     RET

LEVEL_Y1_Z_C:
 RCALL OK_HOLD
  LDS REG16,SAVE_I2C_DATA
   TST REG16
    BREQ SAVE_FLAG_NONE
     LDS REG16,MENU_X
      TST REG16
       BREQ SAVE_TIME_TO_DS3231
        RCALL I2C_SAVE_DATE_TO_DS3231
         CLR REG16
          STS SAVE_I2C_DATA,REG16
           RJMP SAVE_FLAG_NONE

SAVE_TIME_TO_DS3231:
 RCALL I2C_SAVE_TIME_TO_DS3231
  CLR REG16
   STS SAVE_I2C_DATA,REG16

SAVE_FLAG_NONE:
 LDS REG16,KEY_CODE
  CPI REG16,'N'
   BRNE SAVE_FLAG_NONE_OUT
    LDS REG16,OK_FLIP
     TST REG16
      BREQ SAVE_FLAG_NONE_OUT
       CLR REG16
        STS OK_FLIP,REG16
         LDI REG16,2
          STS MENU_Y,REG16

SAVE_FLAG_NONE_OUT:
 RET
;-----------------------------------------------
;ÔÓÍÊÖ²¯ ÄÈÍÀÌ²×ÍÎÃÎ ÂÈÂÎÄÓ
;-----------------------------------------------
SEG_DOTS_SET_INDICATE:
 LDS REG16,MENU_Y
  TST REG16
   BREQ TMO2
    LDS REG16,MENU_Z
     TST REG16
      BRNE TMZ0
       LDS REG16,SUB_MENU_6
        CPI REG16,0
         BRNE DOT_1
          RCALL ON_0_DOT
           RJMP TMO2

DOT_1:
 CPI REG16,1
  BRNE DOT_2
   RCALL ON_1_DOT
    RJMP TMO2

DOT_2:
 CPI REG16,2
  BRNE DOT_3
   RCALL ON_2_DOT
    RJMP TMO2

DOT_3:
 CPI REG16,3
  BRNE TMO2
   RCALL ON_3_DOT
    RJMP TMO2

TMZ0:
 LDS REG16,SUB_MENU_6
  CPI REG16,2
   BRNE NDOT_1
    RCALL ON_0_DOT
     RJMP TMO2

NDOT_1:
 CPI REG16,3
  BRNE NDOT_2
   RCALL ON_1_DOT
    RJMP TMO2

NDOT_2:
 CPI REG16,4
  BRNE NDOT_3
   RCALL ON_2_DOT
    RJMP TMO2

NDOT_3:
 CPI REG16,5
  BRNE TMO2
   RCALL ON_3_DOT

TMO2:
  RET
;----------------------
ON_0_DOT: ;ÂÈÂ²Ä ÏÐÀÂÎ¯ ÒÎ×ÊÈ
 RCALL CLR_DOTS_ALL
  LDI REG16,1
   STS SEG_0_DOT_ACTIVATE,REG16
    RCALL FLASH_BACK_START
     RET
;----------------------
ON_1_DOT: ;ÂÈÂ²Ä ÑÅÍÒÐÀËÜÍÎ-ÏÐÀÂÎ¯ ÒÎ×ÊÈ
 RCALL CLR_DOTS_ALL
  LDI REG16,1
   STS SEG_1_DOT_ACTIVATE,REG16
    RCALL FLASH_BACK_START
     RET
;----------------------
ON_2_DOT: ;ÂÈÂ²Ä ÑÅÍÒÐÀËÜÍÎ-Ë²ÂÎ¯ ÒÎ×ÊÈ
 RCALL CLR_DOTS_ALL
  LDI REG16,1
   STS SEG_2_DOT_ACTIVATE,REG16
    RCALL FLASH_BACK_START
     RET
;----------------------
ON_3_DOT: ;ÂÈÂ²Ä Ë²ÂÎ¯ ÒÎ×ÊÈ
 RCALL CLR_DOTS_ALL
  LDI REG16,1
   STS SEG_3_DOT_ACTIVATE,REG16
    RCALL FLASH_BACK_START
     RET
;----------------------
ON_ALL_DOT: ;ÂÈÂ²Ä ÂÑ²Õ ÒÎ×ÎÊ
 LDI REG16,1
  STS SEG_0_DOT_ACTIVATE,REG16
   STS SEG_1_DOT_ACTIVATE,REG16
    STS SEG_2_DOT_ACTIVATE,REG16
     STS SEG_3_DOT_ACTIVATE,REG16
      RCALL FLASH_BACK_START
       RET
;----------------------
CLR_KC_R_DDOTS: ;Î×ÈÑÒÊÀ ÊÎÄÓ ÊÍÎÏÊÈ + ÏÐÀÂ² 2 ÒÎ×ÊÈ õ 2ÑÅÊ
 CLR REG16
  STS KEY_CODE,REG16
   RCALL CLR_DOTS_ALL
    LDI REG16,1
     STS SEG_0_DOT_ACTIVATE,REG16
      STS SEG_1_DOT_ACTIVATE,REG16
       RCALL FLASH_BACK_START
        RET
;----------------------
CLR_KC_L_DDOTS: ;Î×ÈÑÒÊÀ ÊÎÄÓ ÊÍÎÏÊÈ + Ë²Â² 2 ÒÎ×ÊÈ õ 2ÑÅÊ
 CLR REG16
  STS KEY_CODE,REG16
   RCALL CLR_DOTS_ALL
    LDI REG16,1
     STS SEG_2_DOT_ACTIVATE,REG16
      STS SEG_3_DOT_ACTIVATE,REG16
       RCALL FLASH_BACK_START
        RET
;----------------------
CLR_DOTS_ALL: ;Î×ÈÑÒÊÀ ÒÎ×ÎÊ
 CLR REG16
  ;STS KEY_CODE,REG16
   STS SEG_0_DOT_ACTIVATE,REG16
    STS SEG_1_DOT_ACTIVATE,REG16
     STS SEG_2_DOT_ACTIVATE,REG16
      STS SEG_3_DOT_ACTIVATE,REG16
       RET
;-----------------------------------------------
;ÔÓÍÊÖ²¯ ÇÌ²ÍÈ ÏÎËÎÆÅÍÍß ÌÅÍÞ
;-----------------------------------------------
LEFT_X_SLIDE: ;²ÍÊÐÈÌÅÍÒ Õ-ÃÎÐÈÇÎÍÒÀË²
 LDS REG16,MENU_X
  ;CPI REG16,2
   ;BRSH LEFT_X_SLIDE_OUT
    INC REG16
     STS MENU_X,REG16

LEFT_X_SLIDE_OUT:
 RCALL CLR_KC_R_DDOTS
  CLR REG16
   STS KEY_CODE,REG16
    RET
;----------------------
RIGHT_X_SLIDE: ;ÄÅÊÐÈÌÅÍÒ Õ-ÃÎÐÈÇÎÍÒÀË²
 LDS REG16,MENU_X
  ;TST REG16
   ;BREQ RIGHT_X_SLIDE_OUT
    DEC REG16
     STS MENU_X,REG16

RIGHT_X_SLIDE_OUT:
 RCALL CLR_KC_L_DDOTS
  CLR REG16
   STS KEY_CODE,REG16
    RET
;----------------------
VERTICAL_Y_SLIDE_D: ;²ÍÊÐÈÌÅÍÒ Ó-ÂÅÐÒÈÊÀË²
 LDS REG16,MENU_Y
  ;CPI REG16,2
   ;BRSH Y_SLIDE_D_OUT
    INC REG16
     STS MENU_Y,REG16

Y_SLIDE_D_OUT:
 CLR REG16
  STS KEY_CODE,REG16
   RET
;----------------------
;VERTICAL_Y_SLIDE_U: ;ÄÅÊÐÈÌÅÍÒ Ó-ÂÅÐÒÈÊÀË²
; LDS REG16,MENU_Y
;  TST REG16
;   BREQ Y_SLIDE_U_OUT
;    DEC REG16
;     STS MENU_Y,REG16

;Y_SLIDE_U_OUT:
; CLR REG16
;  STS KEY_CODE,REG16
;   RET
;----------------------
OK_HOLD: ;ÔÓÍÊÖ²ß ÂÈÇÍÀ×ÅÍÍß ÇÀÆÀÒÎ¯ ÊÍÎÏÊÈ "ÎÊ"
 LDS REG16,KEY_CODE
  CPI REG16,'C'
   BRNE HOLD_CLR
    LDS REG16,PUSH_TIME_FLIP
     TST REG16
      BREQ START_1HZ_TIMER
       LDS REG16,IN_SYSTEM_CLOCK
        CPI REG16,1
         BRNE ON_HOLD_OUT
           CLR REG16
           STS MENU_Y,REG16
            STS KEY_CODE,REG16
             STS OK_FLIP,REG16
              LDI REG16,1
               STS SAVE_I2C_DATA,REG16
                RCALL HOLD_CLR
                 RJMP ON_HOLD_OUT

START_1HZ_TIMER:
 CLR REG16
  STS IN_SYSTEM_CLOCK,REG16
   RCALL TIMER_INIT_1
    LDI REG16,1
     STS PUSH_TIME_FLIP,REG16
      STS OK_FLIP,REG16

ON_HOLD_OUT:
 RET
;----------------------
HOLD_CLR: ;ÔÓÍÊÖ²ß ÎÍÓËÅÍÍß ÏÐÎÖÅÑ²Â ÊÎËÈ ÊÍÎÏÊÓ "ÎÊ" Â²ÄÆÀÒÎ ÏÅÐÅÄ×ÀÑÍÎ
 RCALL TIMER_DEINIT_1
  CLR REG16
   STS PUSH_TIME_FLIP,REG16
    STS IN_SYSTEM_CLOCK,REG16
     RET












;-----------------------
;----SEG_DOTS_START-----
;----------------------------------------------
FLASH_BACK_START:
 RCALL TIMER_DEINIT_2
  CLR REG16 
   STS FLASH_SYSTEM_CLOCK,REG16
    RCALL TIMER_INIT_2
     RET
;----------------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------
;----SEG_DOTS_STOP------
;----------------------------------------------
FLASH_BACK_DROP:
 CLR REG16 
  STS FLASH_SYSTEM_CLOCK,REG16
   STS SEG_0_DOT_ACTIVATE,REG16
    STS SEG_1_DOT_ACTIVATE,REG16
     STS SEG_2_DOT_ACTIVATE,REG16
      STS SEG_3_DOT_ACTIVATE,REG16
       RCALL TIMER_DEINIT_2
        RET
;----------------------------------------------
;------PROC_END---------
;-----------------------



;-----------------------
;----SCRN_CLR_PROC------
;----------------------------------------------
SCRN_CLR:
 CBI PORTD,1
  CBI PORTD,2
   CBI PORTD,5
    CBI PORTD,6
     CBI PORTD,7
      ;CBI PORTB,1
       RET
;----------------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------
;--CHNG_SYBM_OUT_PROC---
;----------------------------------------------

;----------------------------------------------
;------PROC_END---------
;-----------------------

;--------------------------------------
;--------INT_BLOCKS--------------------
;--------------------------------------
TIMER0_COMP_A:
 PUSH REG16
  IN REG16,SREG
   PUSH REG16
    PUSH REG17
     PUSH ZregL
      PUSH ZregH
       RCALL SCRN_CLR
        RCALL SYMB_OUTPUT
         RCALL HALT_INCREMENT
          POP ZregH
           POP ZregL
            POP REG17
             POP REG16
              OUT SREG,REG16
               POP REG16
                RETI

TIMER1_COMP_A:
 PUSH REG16
  IN REG16,SREG
   PUSH REG16
    LDI REG16,1
     STS IN_SYSTEM_CLOCK,REG16
      POP REG16
       OUT SREG,REG16
        POP REG16
         RETI

TIMER2_COMP_A:
 PUSH REG16
  IN REG16,SREG
   PUSH REG16
    LDS REG16,FLASH_SYSTEM_CLOCK
     INC REG16
      STS FLASH_SYSTEM_CLOCK,REG16
       CPI REG16,70
        BRNE T2CA
         RCALL FLASH_BACK_DROP

T2CA:
 POP REG16
  OUT SREG,REG16
   POP REG16
    RETI


;--------------------------------------
;
;--------------------------------------

;--------------------------------------
;-----------INIT-----------------------
;--------------------------------------










MASS:
.DB 'A','r','c','A','n','g','e','l','i','d','@','e','x','.','u','a'



